---
generated_at: 2026-02-04 10:05:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：52-フォームレイアウト（Foundation 6）

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  - なし。全主張にソースコード根拠あり。

## 2) 参照した情報（Evidence一覧）

- E-01: `src/Symfony/Bridge/Twig/Resources/views/Form/foundation_6_layout.html.twig`（テンプレートソースコード、51行）
- E-02: `src/Symfony/Bridge/Twig/Resources/views/Form/form_div_layout.html.twig`（親テーマソースコード、482行）
- E-03: `src/Symfony/Bridge/Twig/Resources/views/Form/foundation_5_layout.html.twig`（Foundation 5テーマ、346行 - 比較用）
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv`（画面一覧）
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`（機能マッピング）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | form_div_layout.html.twigを継承している | E-01 行1 `{% extends 'form_div_layout.html.twig' %}` | ○ |
| C-02 | 4つのブロックのみオーバーライドしている | E-01（checkbox_row, money_widget, percent_widget, button_widget の4ブロック） | ○ |
| C-03 | checkbox_rowでswitch-inputクラスの有無を判定する | E-01 行5 `{% if 'switch-input' in parent_class %}` | ○ |
| C-04 | Switch Input時にswitch-inputクラスとswitch-paddleラベルを生成する | E-01 行7 `switch-input`, 行9 `<label class="switch-paddle">` | ○ |
| C-05 | money_widgetでinput-groupコンポーネントを使用する | E-01 行20 `<div class="input-group">` | ○ |
| C-06 | 通貨記号の位置判定にstarts with/ends withを使用する | E-01 行17 `not (money_pattern starts with '{{')`, `not (money_pattern ends with '}}')` | ○ |
| C-07 | input-group-labelクラスで通貨記号を表示する | E-01 行22 `<span class="input-group-label">` | ○ |
| C-08 | input-group-fieldクラスで入力フィールドを表示する | E-01 行24 `{% set attr = attr\|merge({class: ... 'input-group-field'}) %}` | ○ |
| C-09 | percent_widgetでsymbol有無によりinput-groupを使用する | E-01 行36 `{% if symbol %}`, 行37 `<div class="input-group">` | ○ |
| C-10 | button_widgetでbuttonクラスを付与する | E-01 行48 `{% set attr = attr\|merge({class: ... 'button'}) %}` | ○ |
| C-11 | Foundation 5テーマと比較して大幅に簡素化されている | E-01（51行） vs E-03（346行） | ○ |
| C-12 | エラー表示は親テーマのform_errorsをそのまま使用する | E-01にform_errorsブロックのオーバーライドなし、E-02 行413-421 | ○ |
| C-13 | 関連機能としてForm（No.34）とTwig Bridge（No.36）が主機能 | E-05 行130-131 | ○ |
| C-14 | parent_classの初期値としてattr.classが使用される | E-01 行4 `parent_class\|default(attr.class\|default(''))` | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全主張がソースコードから確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] 4つのオーバーライドブロックが正確に記載されているか確認
- [ ] Switch Input機能の説明が正確か確認
- [ ] Foundation 5テーマとの差分記述が適切か確認
